# Telegram Guarantee Bot

ربات تلگرام صدور گارانتی که با `python-telegram-bot` و پایگاه‌داده SQLite پیاده‌سازی شده است. تصاویر فاکتور، اطلاعات مشتری/فروشگاه و کارت PDF در سمت سرور ذخیره می‌شود و برای مدیران ارسال خواهد شد.

## نصب و اجرای محلی
1. ساخت محیط مجازی:
   ```powershell
   python -m venv .venv
   .\.venv\Scripts\Activate.ps1
   ```
2. بروزرسانی `pip` و نصب وابستگی‌ها:
   ```powershell
   python -m pip install --upgrade pip
   pip install -r requirements.txt
   ```
3. فایل `.env` را از روی قالب `.env.example` بسازید و مقادیر زیر را تکمیل کنید:
   - `BOT_TOKEN`: توکن صادر شده توسط `@BotFather`
   - `ADMIN_IDS`: فهرست شناسه‌های تلگرام مدیران به صورت عددی و جدا شده با ویرگول
4. اجرای ربات:
   ```powershell
   python bot_ptb.py 
   ```

## پیکربندی و لاگ
- ربات هیچ خروجی‌ای در ترمینال چاپ نمی‌کند. تمام رخدادها در فایل چرخشی `logs/bot.log` ذخیره می‌شوند. برای مشاهده زنده می‌توانید از `tail -f logs/bot.log` استفاده کنید.
- دیتابیس پیش‌فرض `guarantees.db` است. در محیط‌های تولید پیشنهاد می‌شود از مسیرهای بکاپ‌گیری خودکار استفاده کنید.

## آماده‌سازی برای استقرار روی VPS / سی‌پنل VIPHost
محیط کاربر: دامنه `botnegar.ir`، سی‌پنل در `https://sbot14.viphostnet.net:2083`.

### 1. آماده‌سازی سرور
1. ورود به سی‌پنل و بازکردن بخش **Terminal** یا اتصال SSH به کاربر VPS.
2. آپلود سورس (از طریق File Manager یا `git clone`).
3. ایجاد محیط مجازی و نصب وابستگی‌ها:
   ```bash
   cd ~/tg_guarantee_bot_final
   python3 -m venv .venv
   source .venv/bin/activate
   python -m pip install --upgrade pip
   pip install -r requirements.txt
   cp .env.example .env
   nano .env   # مقادیر واقعی BOT_TOKEN و ADMIN_IDS
   ```
4. در صورت نیاز به مدیریت افزونه‌های PHP در سی‌پنل، از بخش **Select PHP Version** استفاده کنید؛ این پروژه صرفاً به Python 3.10+ نیاز دارد.

### 2. اجرای پایدار
- **گزینه systemd (در صورت دسترسی روت):**
  ```ini
  [Unit]
  Description=Telegram Guarantee Bot
  After=network.target

  [Service]
  WorkingDirectory=/home/<user>/tg_guarantee_bot_final
  Environment="PYTHONUNBUFFERED=1"
  ExecStart=/home/<user>/tg_guarantee_bot_final/.venv/bin/python bot_ptb.py
  Restart=always
  User=<user>

  [Install]
  WantedBy=multi-user.target
  ```
  سپس `sudo systemctl enable --now guarantee-bot`.

- **گزینه بدون دسترسی روت:** اجرای طولانی با `tmux`، `screen` یا `nohup`:
  ```bash
  source ~/tg_guarantee_bot_final/.venv/bin/activate
  nohup python bot_ptb.py >/dev/null 2>&1 &
  ```

### 3. نکات سرویس VIPHost
- همه سرویس‌ها SSL رایگان دارند؛ در صورت مهاجرت آینده به Webhook، دامنه یا زیردامنه را روی HTTPS تست کنید.
- برای مشاهده وضعیت منابع می‌توانید از ربات‌های ارائه‌شده توسط میزبان استفاده کنید:
  - `@tools_viphostbot`
  - `@viphostingbot`
- از زیردامنه اختصاصی سرویس ربات فقط برای Webhook/Backend استفاده کنید؛ ایجاد صفحه وب روی آن طبق قوانین هاست ممنوع است.

### 4. نظارت و نگهداشت
- وضعیت ربات را از فایل `logs/bot.log` بررسی کنید (عدم نیاز به خروجی ترمینال).
- برای بروزرسانی: از داخل پوشه پروژه `git pull` یا فایل جدید را آپلود کرده، سپس `pip install -r requirements.txt` و در نهایت سرویس را ریستارت کنید.
- برای بکاپ، فایل‌های `guarantees.db`, `photos/` و `logs/` را در بازه‌های منظم به فضای امن منتقل کنید.

## متغیرهای کلیدی
| نام | توضیح |
|-----|-------|
| `BOT_TOKEN` | توکن ربات تلگرام |
| `ADMIN_IDS` | لیست ادمین‌ها (عدد) |
| `API_ID`, `API_HASH` | فقط در صورت اضافه شدن کلاینت MTProto لازم خواهد شد |

پس از اعمال تغییرات موردنیاز خود، به من اطلاع دهید تا گام‌های بعدی توسعه یا سفارشی‌سازی را انجام دهیم.
