from alembic import op
import sqlalchemy as sa

from app.db.types import GUID


TABLE_KWARGS = {"mysql_engine": "InnoDB", "mysql_charset": "utf8mb4"}


revision = "0002_catalog"
down_revision = "0001_base"
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "category",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("tenant_id", GUID(), sa.ForeignKey("tenant.id", ondelete="CASCADE"), nullable=False),
        sa.Column("name", sa.String(255), nullable=False),
        sa.Column("parent_id", GUID(), sa.ForeignKey("category.id", ondelete="SET NULL")),
        sa.Column("created_at", sa.TIMESTAMP(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.TIMESTAMP(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.UniqueConstraint("tenant_id", "name", name="uq_category_tenant_name"),
        **TABLE_KWARGS,
    )

    op.create_table(
        "product",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("tenant_id", GUID(), sa.ForeignKey("tenant.id", ondelete="CASCADE"), nullable=False),
        sa.Column("sku", sa.String(255), nullable=False),
        sa.Column("title", sa.Text(), nullable=False),
        sa.Column("name", sa.Text()),
        sa.Column("description", sa.Text()),
        sa.Column("base_price", sa.Numeric(12, 2), nullable=False),
        sa.Column("image_file_id", sa.Text()),
        sa.Column("active", sa.Boolean(), nullable=False, server_default=sa.text("TRUE")),
        sa.Column("stock", sa.Integer(), nullable=False, server_default="0"),
        sa.Column("created_at", sa.TIMESTAMP(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.TIMESTAMP(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.UniqueConstraint("tenant_id", "sku", name="uq_product_tenant_sku"),
        **TABLE_KWARGS,
    )
    op.create_index("idx_product_tenant_active", "product", ["tenant_id", "active"])

    op.create_table(
        "product_image",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("product_id", GUID(), sa.ForeignKey("product.id", ondelete="CASCADE"), nullable=False),
        sa.Column("telegram_file_id", sa.Text(), nullable=False),
        sa.Column("sort_order", sa.Integer(), nullable=False, server_default="0"),
        **TABLE_KWARGS,
    )
    op.create_index("idx_product_image_pid", "product_image", ["product_id"])

    op.create_table(
        "product_spec",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("product_id", GUID(), sa.ForeignKey("product.id", ondelete="CASCADE"), nullable=False),
        sa.Column("name", sa.String(255), nullable=False),
        sa.Column("values", sa.Text(), nullable=False),
        sa.UniqueConstraint("product_id", "name", name="uq_product_spec_name"),
        **TABLE_KWARGS,
    )
    op.create_index("idx_product_spec_pid_name", "product_spec", ["product_id", "name"])

    op.create_table(
        "product_category",
        sa.Column("product_id", GUID(), sa.ForeignKey("product.id", ondelete="CASCADE"), primary_key=True),
        sa.Column("category_id", GUID(), sa.ForeignKey("category.id", ondelete="CASCADE"), primary_key=True),
        **TABLE_KWARGS,
    )


def downgrade():
    op.drop_table("product_category")
    op.drop_index("idx_product_spec_pid_name", table_name="product_spec")
    op.drop_table("product_spec")
    op.drop_index("idx_product_image_pid", table_name="product_image")
    op.drop_table("product_image")
    op.drop_index("idx_product_tenant_active", table_name="product")
    op.drop_table("product")
    op.drop_table("category")
