from __future__ import annotations
from typing import Optional
from pydantic import BaseModel, UUID4


class CategoryCreate(BaseModel):
    name: str
    parent_id: Optional[UUID4] = None


class CategoryUpdate(BaseModel):
    name: Optional[str] = None
    parent_id: Optional[UUID4] = None


class CategoryOut(BaseModel):
    id: UUID4
    name: str
    parent_id: Optional[UUID4]
