from __future__ import annotations
from typing import Optional, Literal, List
from pydantic import BaseModel, Field, UUID4


class StoreProfileIn(BaseModel):
    about_text: Optional[str] = None
    support_text: Optional[str] = None
    contact_phone: Optional[str] = None
    logo_file_id: Optional[str] = None
    channel_id: Optional[str] = None
    channel_invite_link: Optional[str] = None
    manager_telegram_ids: Optional[List[int]] = None
    payment_link_template: Optional[str] = None
    payment_link_note: Optional[str] = None


class StoreProfileOut(StoreProfileIn):
    updated_at: Optional[str]


class StoreSettingsOut(BaseModel):
    tenant_id: UUID4
    manager_telegram_ids: List[int] = Field(default_factory=list)
    payment_link_template: Optional[str]
    payment_link_note: Optional[str]


class StoreChannelInfo(BaseModel):
    tenant_id: UUID4
    channel_id: Optional[str]
    channel_invite_link: Optional[str]


class TenantCreate(BaseModel):
    code: Optional[str] = None
    title: str
    category: Optional[str] = None
    address: Optional[str] = None
    geo_location: Optional[dict] = None
    work_hours: Optional[str] = None
    subscription_tier: Literal["base", "silver", "gold"] = "base"
    store_admin_phone: str
    store_admin_username: Optional[str] = None
    store_admin_password: Optional[str] = None
    bot_token: str
    contact_phone: Optional[str] = None


class TenantUpdate(BaseModel):
    title: Optional[str] = None
    category: Optional[str] = None
    address: Optional[str] = None
    geo_location: Optional[dict] = None
    work_hours: Optional[str] = None
    subscription_tier: Optional[Literal["base", "silver", "gold"]] = None
    status: Optional[Literal["active", "inactive"]] = None
    contact_phone: Optional[str] = None


class TenantOut(BaseModel):
    id: UUID4
    code: str
    title: str
    subscription_tier: str
    status: str
    category: Optional[str]
    address: Optional[str]


class TenantDetail(TenantOut):
    contact_phone: Optional[str]
    work_hours: Optional[str]


class TenantAdminCreate(BaseModel):
    username: str
    password: str
    phone: Optional[str]


class TenantAdminOut(BaseModel):
    id: UUID4
    username: str
    role: str
    status: str


class TenantNotification(BaseModel):
    message: str
