from __future__ import annotations
from typing import Optional, Literal
from pydantic import BaseModel, UUID4


class UserCreate(BaseModel):
    username: str
    password: str
    role: Literal["store_admin", "store_staff", "customer"]
    phone: Optional[str]


class UserUpdate(BaseModel):
    username: Optional[str]
    password: Optional[str]
    status: Optional[Literal["active", "disabled"]]
    phone: Optional[str]


class UserOut(BaseModel):
    id: UUID4
    username: str
    role: str
    status: str
