import argparse
import asyncio
from aiogram import Bot, Dispatcher
from aiogram.client.session.aiohttp import AiohttpSession

from app.core.logging import setup_logging
from app.core.config import get_settings
from app.bots.store import handlers


async def main() -> None:
    parser = argparse.ArgumentParser(description="Run a store bot for a specific tenant")
    parser.add_argument("--tenant-id", required=True)
    parser.add_argument("--token", required=True, help="Telegram bot token")
    args = parser.parse_args()

    setup_logging()
    settings = get_settings()
    session = AiohttpSession(proxy=settings.PROXY_URL) if settings.PROXY_URL else None

    # Inject tenant context for this process
    handlers.STORE_TENANT_ID_CTX.set(args.tenant_id)

    bot = Bot(token=args.token, session=session)
    dp = Dispatcher()
    dp.include_router(handlers.router)
    await dp.start_polling(bot)


if __name__ == "__main__":
    asyncio.run(main())

