from datetime import datetime
from typing import List
from pydantic import BaseModel


class ReportFilters(BaseModel):
    date_from: datetime
    date_to: datetime


class OrderReportRow(BaseModel):
    order_id: str
    total: float
    status: str
    payment_method: str | None
    created_at: datetime


class OrdersReport(BaseModel):
    rows: List[OrderReportRow]
    total_amount: float
