from fastapi import APIRouter, Depends, HTTPException
from sqlalchemy.orm import Session
from app.api.dependencies import get_db, get_tenant_context, require_roles
from app.schemas.payment import PaymentConfirmRequest, PaymentCallback
from app.services.payments import get_payment, update_payment_status
from app.schemas.order import PaymentStatusUpdate


router = APIRouter(prefix="/payments", tags=["payments"])


@router.post("/card2card/confirm")
def confirm_card2card(
    payload: PaymentConfirmRequest,
    tenant=Depends(get_tenant_context),
    db: Session = Depends(get_db),
    _: object = Depends(require_roles("store_admin", "store_staff")),
):
    payment = get_payment(db, str(payload.payment_id))
    if not payment or str(payment.tenant_id) != str(tenant.id):
        raise HTTPException(status_code=404, detail="payment not found")
    updated = update_payment_status(
        db,
        payment,
        PaymentStatusUpdate(status=payload.status, gateway_tx_id=payload.gateway_tx_id, card2card_note=payload.card2card_note),
    )
    return {"id": str(updated.id), "status": updated.status}


@router.post("/online/callback")
def online_callback(payload: PaymentCallback, db: Session = Depends(get_db)):
    payment = get_payment(db, str(payload.payment_id))
    if not payment:
        raise HTTPException(status_code=404, detail="payment not found")
    updated = update_payment_status(
        db,
        payment,
        PaymentStatusUpdate(status=payload.status, gateway_tx_id=payload.gateway_tx_id, card2card_note=None),
    )
    return {"id": str(updated.id), "status": updated.status}

