import asyncio
from aiogram import Bot, Dispatcher
from aiogram.client.session.aiohttp import AiohttpSession
from app.core.config import get_settings
from app.bots.hyper import handlers, account_purchase_handlers


async def main():
    settings = get_settings()
    if not settings.HYPER_BOT_TOKEN:
        raise RuntimeError("HYPER_BOT_TOKEN is not configured")
    session = AiohttpSession(proxy=settings.PROXY_URL) if settings.PROXY_URL else None
    bot = Bot(token=settings.HYPER_BOT_TOKEN, session=session)
    dp = Dispatcher()
    dp.include_router(handlers.router)
    dp.include_router(account_purchase_handlers.router)
    await dp.start_polling(bot)


if __name__ == "__main__":
    asyncio.run(main())
