# ربات فروشگاه Hyper Store – سند نیازمندی‌ها و جریان‌ها

این سند، نسخه‌ی بازنگری‌شده‌ی سناریو و تعاملات دو ربات «هایپر» و «فروشگاه» را توصیف می‌کند. هدف این است که تمام تعاملات از طریق منوها انجام شود، امکان بازگشت و لغو در هر مرحله فراهم باشد، وضعیت پردازش به‌وضوح نمایش داده شود، و ارتباط ربات با کانال اختصاصی هر فروشگاه برقرار گردد.

## ۱. معماری کلی و مفاهیم

| مفهوم | توضیح |
| --- | --- |
| **Hyper Bot** | ربات مدیریتی برای Hyper Admin که ثبت/مدیریت مارکت‌ها، مدیران و اعلان‌ها را کنترل می‌کند. |
| **Store Bot** | ربات هاب برای مدیران فروشگاه و مشتریان؛ مدیر با آن محتوا ثبت می‌کند و مشتری از طریق آن وارد کانال فروشگاه می‌شود. |
| **کانال اختصاصی فروشگاه** | هر فروشگاه یک کانال تلگرام دارد که محصولات در آن منتشر می‌شوند. شناسه کانال در تنظیمات فروشگاه ذخیره می‌شود و bot به عنوان Admin در کانال حضور دارد. |
| **Like/Bookmark** | مشتری در کانال با زدن دکمه «لایک» روی محصولات، آن‌ها را نشانه‌گذاری می‌کند تا در بازگشت به ربات، یک سبد موقت تشکیل شود. |
| **سبد موقت** | فهرست محصولات لایک‌شده در یک بازه‌ی بازدید. مشتری در ربات می‌تواند تعداد را ویرایش، حذف، ذخیره یا خرید را قطعی کند. |
| **سفارش** | نتیجه‌ی نهایی checkout مشتری، شامل اطلاعات تماس، روش پرداخت و وضعیت سفارش. |

## ۲. جریان‌های کاربری

### ۲.۱ Hyper Admin (Hyper Bot)

1. **ورود**: از طریق دکمه‌ی «مدیریت هایپر» → دکمه‌های Username / Password (با Reply Keyboard).  
2. **داشبورد**: منوی اصلی شامل:  
   - «ثبت مارکت جدید» (ویزارد دکمه‌ای)  
   - «مدیریت مارکت‌ها»  
   - «تنظیمات پایه»  
   - «بازگشت»
3. **ثبت مارکت جدید** (تماماً دکمه‌ای):  
   - انتخاب کشور/نام شهر/نام فروشگاه از لیست‌ها یا گزینه «+ افزودن» با تایید دو مرحله‌ای.  
   - انتخاب نوع اشتراک، دسته‌بندی، کانال (ورود channel_id با انتخاب از لیست کانال‌های ثبت شده یا دکمه «افزودن کانال»).  
   - جمع‌بندی و دکمه‌های «تایید / لغو / بازگشت».  
   - نمایش پیام وضعیت (⌛ «در حال ثبت مارکت…») تا پاسخ API بیاید.
4. **مدیریت مارکت‌ها**:  
   - لیست مارکت‌ها با وضعیت (فعال/غیرفعال).  
   - پس از انتخاب مارکت: نمایش خلاصه + دکمه‌های عملیات (فعال/غیرفعال، افزودن مدیر، ویرایش پروفایل، کانال، ارسال نوتیف).  
   - هر عملیات با دکمه‌های مرحله‌ای، Loader و دکمه‌های بازگشت/لغو.
5. **لاگینگ**: هر اکشن مهم Hyper Admin در `logs/hyper_bot/hyper.log` (JSON) ثبت می‌شود: timestamp، user_id، action، نتیجه/خطا.

### ۲.۲ Store Admin (Store Bot)

1. **ورود مدیر**: دکمه «مدیریت مارکت» → فرم Username/Password متنی → منوی Reply با گزینه‌های «محصولات»، «دسته‌بندی‌ها»، «سفارش‌ها»، «کانال فروشگاه» و «خروج».  
   - **محصولات**:  
     - «ثبت محصول جدید» یک ویزارد ۶ مرحله‌ای (عنوان، توضیح، قیمت پایه، درصد تخفیف، موجودی، تصویر) است؛ در هر مرحله فقط یک ورودی پذیرفته می‌شود و دکمه‌های «⬅️ بازگشت» و «❌ لغو» در دسترس‌اند.  
     - خروجی ویزارد بدون انتخاب دسته/ویژگی مستقیماً در `/products` ذخیره می‌شود و `sku` از عنوان ساخته می‌شود.  
     - دکمه‌های «محصولات فعال/غیرفعال» صرفاً لیست متنی (حداکثر ۲۰ مورد) را برمی‌گردانند؛ هنوز دکمه‌ای برای ویرایش، تغییر وضعیت یا حذف وجود ندارد.  
   - **دسته‌بندی‌ها**: افزودن نام جدید و مشاهده‌ی لیست فعلی (ویرایش/حذف پیاده‌سازی نشده است).  
   - **سفارش‌ها**: مشاهده‌ی سفارش‌های `saved` و `paid`.  
   - **کانال فروشگاه**: ورود `channel_id` و لینک دعوت + ارسال پیام تست.
2. **مدیریت کانال و پست‌ها**:  
   - اطلاعات کانال در پروفایل tenant ذخیره می‌شود و با دکمه «ارسال تست» یک پیام ساده به کانال فرستاده می‌شود (Bot باید ادمین باشد).  
   - هیچ موتور تولید پست محصول یا صف انتشار خودکاری وجود ندارد؛ تا زمان پیاده‌سازی باید کپشن و مدیا در خود تلگرام ایجاد و منتشر شود یا قابلیت تازه‌ای به ربات افزوده گردد.  
   - لینک عمومی که به مشتری نمایش داده می‌شود از محیط `STORE_CHANNEL_URL` خوانده می‌شود و در حال حاضر بین همه مارکت‌ها مشترک است.
3. **لاگینگ**: همه اکشن‌های مدیر در `logs/store_bot/store.log` ثبت می‌شود (logger `app.bots.store`، فرمت JSON).

### ۲.3 مشتری / Guest Flow (Store Bot + کانال)

1. **ورود به مارکت**: کلید «ورود به فروشگاه» در Store Bot → دریافت منوی اینلاین:
   - «ورود به کانال» (لینک join / یا open via Bot API)  
   - «مشاهده دسته‌بندی‌ها» (در ربات)  
   - «ورود سریع با تلگرام» (برای خرید)  
   - «سبد خرید من» (اگر قبلاً وارد شده باشد)  
   - «بازگشت»
2. **کانال فروشگاه**:  
   - هر محصول در کانال با قالب مشخص و دکمه‌ی «❤️ پسند» و «🔚 پایان بازدید» منتشر می‌شود.  
   - Bot باید ادمین کانال باشد تا Callbackها ثبت شوند.  
   - هنگام ورود به کانال، timestamp «شروع گردش» در دیتابیس ثبت می‌شود.  
   - هر بار که کاربر روی «پایان بازدید» می‌زند، callback به ربات ارسال و لیست محصولات لایک‌شده بین دو timestamp جمع‌آوری می‌شود.
3. **بازگشت به ربات**:  
   - ربات لیست محصولات نشانه‌گذاری شده را با دکمه‌های «➖ حذف»، «✏️ ویرایش تعداد»، «✅ افزودن به سبد» نشان می‌دهد.  
   - در این مرحله کاربر می‌تواند لایک‌های جدید را به cart موقت تبدیل کند یا حذفشان کند.
4. **سبد موقت و Checkout**:  
   - افزودن/حذف/ویرایش تعداد صرفاً با دکمه.  
   - دکمه‌های «ذخیره»، «حذف سبد»، «ادامه خرید».  
   - Checkout:  
     1. اگر حساب ندارد → «ورود سریع با تلگرام» (telegram_login)  
     2. گرفتن اطلاعات تماس/آدرس با کیبوردهای ساختاریافته (مثلاً انتخاب استان/شهر از لیست).  
     3. انتخاب روش پرداخت (card2card، درگاه، پرداخت در محل).  
     4. نمایش خلاصه سفارش، تایید نهایی، نمایش Loader «در حال ایجاد سفارش…».  
   - بعد از تایید سفارش، وضعیت در API به «پرداخت‌شده» یا «در انتظار پرداخت» ثبت و به مدیر اطلاع داده می‌شود.

## ۳. الزامات رابط کاربری و FSM

- **بدون ورودی متنی آزاد**: تمام مقادیر از طریق دکمه‌ها جمع‌آوری می‌شود. اگر نیاز به متن دلخواه باشد (مثل عنوان محصول)، ابتدا دکمه «ارسال عنوان جدید» نمایش داده می‌شود، سپس ربات دستور تایپ را با محدوده معتبر و دکمه «لغو» اعلام می‌کند.
- **بازگشت/لغو**: در هر مرحله دو دکمه موجود است:  
  - «⬅️ بازگشت» → مرحله‌ی قبل یا منوی اصلی همان فرآیند.  
  - «❌ لغو عملیات» → پاک‌سازی وضعیت FSM و بازگشت به منوی ریشه.
- **Loader/در حال پردازش**: برای درخواست‌های شبکه‌ای، از پیام موقتی استفاده می‌شود (مثلاً «⌛ در حال پردازش…») و پس از دریافت پاسخ، پیام با نتیجه جایگزین می‌شود یا Callback edit می‌گردد.
- **هندلینگ تایم‌اوت**: اگر پاسخ API طولانی شد، پیام «لطفاً منتظر بمانید» هر چند ثانیه به‌روزرسانی می‌شود یا با `answerCallbackQuery` کاربر در جریان قرار می‌گیرد.

## ۴. لاگ‌ها

```
logs/
  hyper_bot/hyper.log
  store_bot/store.log
```

- فرمت JSON با فیلدهای حداقل: timestamp، level، bot, user_id، tenant_id (اگر وجود داشت)، action، payload، status/error.
- در صورت نیاز به گردش لاگ، از `RotatingFileHandler` یا معادل در Python استفاده می‌شود.

## ۵. داده‌های جدید موردنیاز

- `channel_id` برای هر فروشگاه (در جدول tenant یا store_profile).  
- جدول/مدل `product_like` برای ذخیره‌ی لایک‌های کانال:  
  - `id`, `tenant_id`, `product_id`, `telegram_user_id`, `liked_at`, `session_id`.  
  - Session برای محدوده‌ی «ورود تا خروج» کاربر از کانال.
- `customer_profile` یا فیلدهای اضافی در `AppUser` برای ذخیره‌ی آدرس، تلفن و …  
- وضعیت سفارش‌ها باید از طریق API قابل گزارش باشد.

## ۶. امنیت و پیام‌های کاربر

- تمام پیام‌های خطا کاربرپسند هستند («متاسفیم، مشکلی پیش آمده…») و در لاگ جزئیات تکنیکی ثبت می‌شود.  
- داده‌های حساس (تلفن، آدرس، پرداخت) رمزنگاری یا حداقل hashed می‌شود.  
- دسترسی ربات به کانال‌ها باید با بررسی Admin بودن چک شود.

## ۷. معیار پذیرش

| بند | معیار |
| --- | --- |
| ۱ | این سند + README به‌روز شده، توالی کامل را شرح می‌دهد. |
| ۲ | هیچ مسیر عملیاتی متن آزاد نمی‌گیرد مگر با دکمه «ارسال مقدار جدید». |
| ۳ | هر مرحله دکمه «بازگشت» و «لغو» دارد و FSM به حالت پایدار برمی‌گردد. |
| ۴ | عملیات شبکه‌ای پیام Loader دارند و تایم‌اوت کنترل می‌شود. |
| ۵ | لاگ‌های bot در پوشه‌های جدا با فرمت JSON ثبت می‌شوند. |
| ۶ | کانال برای هر فروشگاه ثبت و ربات قادر به انتشار و دریافت callback است. |
| ۷ | لایک محصولات ذخیره شده و قابل استخراج برای هر دوره بازدید است. |
| ۸ | دکمه «پایان گردش» کاربر را به ربات بازمی‌گرداند و لیست لایک‌ها نمایش داده می‌شود. |
| ۹ | لیست انتخاب‌شده قابلیت حذف/ویرایش/ذخیره/تایید دارد. |
| ۱۰ | Checkout اطلاعات مشتری را جمع‌آوری و سفارش ثبت‌شده‌ای تولید می‌کند و به مدیر اطلاع می‌دهد. |

پس از تایید این سند، پیاده‌سازی گام‌به‌گام (Backend، Hyper Bot، Store Bot) آغاز می‌شود.
