import pytest
from sqlalchemy import create_engine, text
from sqlalchemy.orm import sessionmaker
from app.db.base import Base
import app.models  # noqa: F401
from app.services.catalog import create_product
from app.schemas.product import ProductCreate
from app.models import Tenant


@pytest.fixture(scope="function")
def db():
    engine = create_engine("sqlite+pysqlite:///:memory:", echo=False)
    Base.metadata.create_all(engine)
    Session = sessionmaker(bind=engine, autoflush=False, autocommit=False)
    sess = Session()
    # seed minimal tenant
    tid = sess.execute(text("INSERT INTO tenant(code, title, subscription_tier, status, created_at, updated_at) VALUES('t','T','base','active',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP) RETURNING id")).scalar()
    sess.commit()
    yield sess
    sess.close()


def test_price_history_on_create(db):
    # insert tenant id explicit
    tid = db.execute(text("SELECT id FROM tenant WHERE code='t'")); tid = tid.scalar()
    p = create_product(
        db,
        str(tid),
        ProductCreate(
            sku="SKU1",
            title="Prod",
            base_price=1000.0,
            discount_percent=10,
            stock=5,
            categories=[],
            specs=[],
            images=[],
        ),
    )
    row = db.execute(text("SELECT count(*) FROM product_price_history WHERE product_id=:pid"), {"pid": str(p.id)}).scalar()
    assert row == 1
