"""channel sessions and likes"""
from alembic import op
import sqlalchemy as sa

from app.db.types import GUID


TABLE_KWARGS = {"mysql_engine": "InnoDB", "mysql_charset": "utf8mb4"}

revision = "0007_channel_sessions"
down_revision = "0006_seed_hyper_admin"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column("store_profile", sa.Column("channel_id", sa.Text(), nullable=True))
    op.add_column("store_profile", sa.Column("channel_invite_link", sa.Text(), nullable=True))

    op.create_table(
        "store_visit",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("tenant_id", GUID(), sa.ForeignKey("tenant.id", ondelete="CASCADE"), nullable=False),
        sa.Column("telegram_user_id", sa.BigInteger(), nullable=False),
        sa.Column("session_token", sa.Text(), nullable=False),
        sa.Column("started_at", sa.DateTime(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("ended_at", sa.DateTime(timezone=True)),
        sa.Column(
            "status",
            sa.Enum("active", "completed", "cancelled", name="store_visit_status"),
            nullable=False,
            server_default=sa.text("'active'"),
        ),
        sa.UniqueConstraint("session_token", name="uq_store_visit_token"),
        **TABLE_KWARGS,
    )

    op.create_table(
        "product_like",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("tenant_id", GUID(), sa.ForeignKey("tenant.id", ondelete="CASCADE"), nullable=False),
        sa.Column("product_id", GUID(), sa.ForeignKey("product.id", ondelete="CASCADE"), nullable=False),
        sa.Column("telegram_user_id", sa.BigInteger(), nullable=False),
        sa.Column("session_id", GUID(), sa.ForeignKey("store_visit.id", ondelete="CASCADE")),
        sa.Column("liked_at", sa.DateTime(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.UniqueConstraint("session_id", "product_id", "telegram_user_id", name="uq_product_like_session"),
        **TABLE_KWARGS,
    )


def downgrade():
    op.drop_table("product_like")
    op.drop_table("store_visit")
    op.drop_column("store_profile", "channel_invite_link")
    op.drop_column("store_profile", "channel_id")
    sa.Enum("active", "completed", "cancelled", name="store_visit_status").drop(op.get_bind(), checkfirst=False)
