from pydantic import BaseModel
from typing import Literal, Optional


class LoginRequest(BaseModel):
    username: str
    password: str
    telegram_user_id: Optional[int] = None


class TokenResponse(BaseModel):
    token: str
    role: Literal["hyper_admin", "store_admin", "store_staff", "customer"]
    tenant_id: str | None
    telegram_user_id: int | None = None
