from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session
from app.api.dependencies import get_db
from app.schemas.lead import LeadIn
from app.services.leads import create_account_request
from app.utils.validators import ensure_iran_phone


router = APIRouter(prefix="/leads", tags=["leads"])


@router.post("/", response_model=dict)
def create_lead(payload: LeadIn, db: Session = Depends(get_db)):
    ensure_iran_phone(payload.phone)
    lead = create_account_request(db, payload.full_name, payload.phone, payload.description)
    return {"id": str(lead.id), "status": lead.status}
