import asyncio
from aiogram import Bot, Dispatcher
from aiogram.client.session.aiohttp import AiohttpSession
from app.core.config import get_settings
from app.core.logging import setup_logging
from app.bots.store import handlers


async def main():
    setup_logging()
    settings = get_settings()
    token = settings.STORE_BOT_TOKEN
    if not token:
        raise RuntimeError("Provide bot token via env")
    session = AiohttpSession(proxy=settings.PROXY_URL) if settings.PROXY_URL else None
    bot = Bot(token=token, session=session)
    dp = Dispatcher()
    dp.include_router(handlers.router)
    await dp.start_polling(bot)


if __name__ == "__main__":
    asyncio.run(main())

