import logging
import time

from bot.handlers.commands import CommandHandler
from bot.services.bale_api import BaleAPI
from utils.logging_utils import setup_logging


def main() -> None:
    setup_logging()
    logger = logging.getLogger(__name__)

    api = BaleAPI()
    handler = CommandHandler(api=api)
    offset: int | None = None
    logger.info("bale-team-bot (Scrumban MVP) started. Listening for updates...")

    while True:
        try:
            updates = api.get_updates(offset=offset)
            for upd in updates:
                offset = max(offset or 0, upd.get("update_id", 0) + 1)
                handler.handle_update(upd)
        except Exception as exc:  # noqa: BLE001
            logger.exception("Error while polling updates; retrying in 5 seconds... %s", exc)
            time.sleep(5)


if __name__ == "__main__":
    main()
